/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui.elements;

import mcjty.lostcities.config.Configuration;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.elements.GuiElement;
import mcjty.lostcities.varia.ComponentFactory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class DoubleElement
extends GuiElement {
    private final GuiLCConfig gui;
    private String label = null;
    private String prefix = null;
    private final EditBox field;
    private final String attribute;

    public DoubleElement(GuiLCConfig gui, String page, int x, int y, int w, String attribute) {
        super(page, x, y);
        this.gui = gui;
        this.attribute = attribute;
        Double c = gui.getLocalSetup().get().map(h -> (Double)h.toConfiguration().get(attribute)).orElse(0.0);
        this.field = new EditBox(this, gui.getFont(), x, y, w, 16, (Component)ComponentFactory.literal(Double.toString(c))){};
        this.field.setResponder(s -> gui.getLocalSetup().get().ifPresent(profile -> {
            Configuration configuration = profile.toConfiguration();
            double value = 0.0;
            try {
                value = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return;
            }
            Configuration.Value val = configuration.getValue(attribute);
            val.set(value);
            if (val.constrain()) {
                this.setValue(val.get());
            }
            profile.copyFromConfiguration(configuration);
            gui.refreshPreview();
        }));
        gui.addWidget(this.field);
    }

    public DoubleElement prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public DoubleElement label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void tick() {
    }

    @Override
    public void render(GuiGraphics graphics) {
        if (this.field.visible) {
            if (this.label != null) {
                graphics.drawString(this.gui.getFont(), this.label, 10, this.y + 5, -1);
            }
            if (this.prefix != null) {
                graphics.drawString(this.gui.getFont(), this.prefix, this.x - 8, this.y + 5, -1);
            }
        }
    }

    @Override
    public void update() {
        this.gui.getLocalSetup().get().ifPresent(profile -> {
            Object result = profile.toConfiguration().get(this.attribute);
            this.setValue(result);
        });
    }

    private void setValue(Object result) {
        if (result instanceof Float) {
            this.field.setValue(Float.toString(((Float)result).floatValue()));
        } else if (result instanceof Double) {
            this.field.setValue(Double.toString((Double)result));
        } else if (result instanceof Integer) {
            this.field.setValue(Integer.toString((Integer)result));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        this.field.setEditable(b);
    }

    @Override
    public void setBasedOnMode(String mode) {
        this.field.setVisible(this.page.equalsIgnoreCase(mode));
    }
}

