/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkDriver {
    private LevelAccessor region;
    private ChunkAccess primer;
    private final BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private SectionCache cache;
    private int cx;
    private int cz;

    public void setPrimer(LevelAccessor region, ChunkAccess primer) {
        this.region = region;
        this.primer = primer;
        if (primer != null) {
            this.cache = new SectionCache(region, primer.getPos().x << 4, primer.getPos().z << 4);
            this.cx = primer.getPos().x;
            this.cz = primer.getPos().z;
        }
    }

    public void actuallyGenerate(ChunkAccess chunk) {
        BulkSectionAccess bulk = new BulkSectionAccess(this.region);
        this.cache.generate(bulk);
        bulk.close();
        BlockState bedrock = Blocks.BEDROCK.defaultBlockState();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y = this.cache.heightmap[x][z];
                if (y <= Integer.MIN_VALUE) continue;
                chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING).update(x, y, z, bedrock);
                chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES).update(x, y, z, bedrock);
                chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR).update(x, y, z, bedrock);
                chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE).update(x, y, z, bedrock);
            }
        }
        this.cache.clear();
    }

    private void setBlock(BlockPos p, BlockState state) {
        if (state != null) {
            this.cache.put(p, state);
        }
    }

    private BlockState getBlockSafe(BlockPos p) {
        return this.isThisChunk(p) ? this.getBlock(p) : this.region.getBlockState(p);
    }

    private BlockState getBlock(BlockPos p) {
        BlockState state = this.cache.get(p);
        if (state == null) {
            state = this.region.getBlockState(p);
            this.cache.put(p, state);
        }
        return state;
    }

    public LevelAccessor getRegion() {
        return this.region;
    }

    public ChunkAccess getPrimer() {
        return this.primer;
    }

    public ChunkDriver current(int x, int y, int z) {
        this.current.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4));
        return this;
    }

    public ChunkDriver currentAbsolute(BlockPos pos) {
        this.current.set((Vec3i)pos);
        return this;
    }

    public ChunkDriver currentRelative(BlockPos pos) {
        this.current(pos.getX(), pos.getY(), pos.getZ());
        return this;
    }

    public BlockPos getCurrentCopy() {
        return this.current.immutable();
    }

    public BlockPos.MutableBlockPos getCurrent() {
        return this.current;
    }

    public void incY() {
        this.current.setY(this.current.getY() + 1);
    }

    public void decY() {
        this.current.setY(this.current.getY() - 1);
    }

    public void incX() {
        this.current.setX(this.current.getX() + 1);
    }

    public void incZ() {
        this.current.setZ(this.current.getZ() + 1);
    }

    public int getX() {
        return this.current.getX();
    }

    public int getY() {
        return this.current.getY();
    }

    public int getZ() {
        return this.current.getZ();
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state) {
        this.pos.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4));
        while (y < y2) {
            this.setBlock((BlockPos)this.pos, state);
            this.pos.setY(++y);
        }
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state, Predicate<BlockState> test) {
        this.pos.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4));
        while (y < y2) {
            BlockState st = this.getBlock((BlockPos)this.pos);
            if (st != state && test.test(st)) {
                this.setBlock((BlockPos)this.pos, state);
            }
            this.pos.setY(++y);
        }
    }

    public void setBlockRangeToAir(int x, int y, int z, int y2) {
        BlockState air = Blocks.AIR.defaultBlockState();
        this.pos.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4));
        while (y < y2) {
            this.setBlock((BlockPos)this.pos, air);
            this.pos.setY(++y);
        }
    }

    public void setBlockRangeToAir(int x, int y, int z, int y2, Predicate<BlockState> test) {
        BlockState air = Blocks.AIR.defaultBlockState();
        this.pos.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4));
        while (y < y2) {
            BlockState st = this.getBlock((BlockPos)this.pos);
            if (st != air && test.test(st)) {
                this.setBlock((BlockPos)this.pos, air);
            }
            this.pos.setY(++y);
        }
    }

    private boolean isThisChunk(BlockPos pos) {
        int px = pos.getX() >> 4;
        int pz = pos.getZ() >> 4;
        return px == this.cx && pz == this.cz;
    }

    private BlockState updateAdjacent(BlockState state, Direction direction, BlockPos pos, ChunkAccess thisChunk) {
        BlockState adjacent = this.getBlockSafe(pos);
        if (adjacent.getBlock() instanceof LadderBlock) {
            return adjacent;
        }
        BlockState newAdjacent = null;
        try {
            newAdjacent = adjacent.updateShape(direction, state, this.region, pos, pos.relative(direction));
        }
        catch (Exception e) {
            return adjacent;
        }
        if (newAdjacent != adjacent) {
            ChunkAccess chunk = this.region.getChunk(pos);
            if (chunk == thisChunk) {
                this.setBlock(pos, newAdjacent);
            } else if (chunk.getPersistedStatus().isOrAfter(ChunkStatus.FULL)) {
                this.region.setBlock(pos, newAdjacent, 2);
            }
        }
        return newAdjacent;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof StairBlock;
    }

    private boolean isDifferentStairs(BlockState state, BlockPos pos, Direction face) {
        BlockPos relative = pos.relative(face);
        BlockState blockstate = this.getBlockSafe(relative);
        return !ChunkDriver.isBlockStairs(blockstate) || blockstate.getValue((Property)StairBlock.FACING) != state.getValue((Property)StairBlock.FACING) || blockstate.getValue((Property)StairBlock.HALF) != state.getValue((Property)StairBlock.HALF);
    }

    private StairsShape getShapeProperty(BlockState state, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.getValue((Property)StairBlock.FACING);
        BlockPos relative = pos.relative(direction);
        BlockState blockstate = this.getBlockSafe(relative);
        if (ChunkDriver.isBlockStairs(blockstate) && state.getValue((Property)StairBlock.HALF) == blockstate.getValue((Property)StairBlock.HALF) && (direction1 = (Direction)blockstate.getValue((Property)StairBlock.FACING)).getAxis() != ((Direction)state.getValue((Property)StairBlock.FACING)).getAxis() && this.isDifferentStairs(state, pos, direction1.getOpposite())) {
            if (direction1 == direction.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockPos relativeOpposite = pos.relative(direction.getOpposite());
        BlockState blockstate1 = this.getBlockSafe(relativeOpposite);
        if (ChunkDriver.isBlockStairs(blockstate1) && state.getValue((Property)StairBlock.HALF) == blockstate1.getValue((Property)StairBlock.HALF) && (direction2 = (Direction)blockstate1.getValue((Property)StairBlock.FACING)).getAxis() != ((Direction)state.getValue((Property)StairBlock.FACING)).getAxis() && this.isDifferentStairs(state, pos, direction2)) {
            if (direction2 == direction.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static WallSide canAttachWall(BlockState state) {
        return ChunkDriver.canAttach(state) ? WallSide.LOW : WallSide.NONE;
    }

    private static boolean canAttach(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        if (state.canOcclude()) {
            return true;
        }
        return !Block.isExceptionForConnection((BlockState)state);
    }

    private BlockState correct(BlockState state) {
        int cx = this.current.getX();
        int cy = this.current.getY();
        int cz = this.current.getZ();
        ChunkAccess thisChunk = this.region.getChunk(cx >> 4, cz >> 4);
        BlockState westState = this.updateAdjacent(state, Direction.EAST, (BlockPos)this.pos.set(cx - 1, cy, cz), thisChunk);
        BlockState eastState = this.updateAdjacent(state, Direction.WEST, (BlockPos)this.pos.set(cx + 1, cy, cz), thisChunk);
        BlockState northState = this.updateAdjacent(state, Direction.SOUTH, (BlockPos)this.pos.set(cx, cy, cz - 1), thisChunk);
        BlockState southState = this.updateAdjacent(state, Direction.NORTH, (BlockPos)this.pos.set(cx, cy, cz + 1), thisChunk);
        if (state.getBlock() instanceof CrossCollisionBlock) {
            state = (BlockState)state.setValue((Property)CrossCollisionBlock.WEST, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(westState)));
            state = (BlockState)state.setValue((Property)CrossCollisionBlock.EAST, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(eastState)));
            state = (BlockState)state.setValue((Property)CrossCollisionBlock.NORTH, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(northState)));
            state = (BlockState)state.setValue((Property)CrossCollisionBlock.SOUTH, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(southState)));
        } else if (state.getBlock() instanceof WallBlock) {
            state = (BlockState)state.setValue((Property)WallBlock.WEST_WALL, (Comparable)ChunkDriver.canAttachWall(westState));
            state = (BlockState)state.setValue((Property)WallBlock.EAST_WALL, (Comparable)ChunkDriver.canAttachWall(eastState));
            state = (BlockState)state.setValue((Property)WallBlock.NORTH_WALL, (Comparable)ChunkDriver.canAttachWall(northState));
            state = (BlockState)state.setValue((Property)WallBlock.SOUTH_WALL, (Comparable)ChunkDriver.canAttachWall(southState));
        } else if (state.getBlock() instanceof StairBlock) {
            state = (BlockState)state.setValue((Property)StairBlock.SHAPE, (Comparable)this.getShapeProperty(state, (BlockPos)this.pos.set(cx, cy, cz)));
        } else if (state.getBlock() instanceof StructureVoidBlock) {
            return null;
        }
        return state;
    }

    public ChunkDriver blockImm(BlockState c) {
        this.setBlock((BlockPos)this.pos, c);
        return this;
    }

    public ChunkDriver block(BlockState c) {
        this.setBlock((BlockPos)this.current, this.correct(c));
        return this;
    }

    public ChunkDriver add(BlockState state) {
        this.setBlock((BlockPos)this.current, this.correct(state));
        this.incY();
        return this;
    }

    public BlockState getBlock() {
        return this.getBlock((BlockPos)this.current);
    }

    public BlockState getBlockDown() {
        return this.getBlock((BlockPos)this.pos.set(this.current.getX(), this.current.getY() - 1, this.current.getZ()));
    }

    public BlockState getBlockEast() {
        return this.getBlock((BlockPos)this.pos.set(this.current.getX() + 1, this.current.getY(), this.current.getZ()));
    }

    public BlockState getBlockWest() {
        return this.getBlock((BlockPos)this.pos.set(this.current.getX() - 1, this.current.getY(), this.current.getZ()));
    }

    public BlockState getBlockSouth() {
        return this.getBlock((BlockPos)this.pos.set(this.current.getX(), this.current.getY(), this.current.getZ() + 1));
    }

    public BlockState getBlockNorth() {
        return this.getBlock((BlockPos)this.pos.set(this.current.getX(), this.current.getY(), this.current.getZ() - 1));
    }

    public BlockState getBlock(int x, int y, int z) {
        return this.getBlock((BlockPos)this.pos.set(x + (this.primer.getPos().x << 4), y, z + (this.primer.getPos().z << 4)));
    }

    private static class SectionCache {
        private final int minY;
        private final int maxY;
        private final int cx;
        private final int cz;
        private final S[] cache;
        private final int[][] heightmap = new int[16][16];

        private SectionCache(LevelAccessor level, int cx, int cz) {
            this.minY = level.getMinBuildHeight();
            this.maxY = level.getMaxBuildHeight();
            this.cx = cx;
            this.cz = cz;
            this.cache = new S[(this.maxY - this.minY) / 16];
            this.clear();
        }

        private void put(BlockPos pos, BlockState state) {
            int sectionIdx = (pos.getY() - this.minY) / 16;
            int px = pos.getX() & 0xF;
            int pz = pos.getZ() & 0xF;
            int idx = (px << 8) + ((pos.getY() & 0xF) << 4) + pz;
            this.cache[sectionIdx].section[idx] = state;
            this.cache[sectionIdx].isEmpty = false;
            if (!state.isAir()) {
                if (this.heightmap[px][pz] < pos.getY()) {
                    this.heightmap[px][pz] = pos.getY();
                }
            } else if (this.heightmap[px][pz] >= pos.getY()) {
                for (int y = pos.getY() - 1; y >= this.minY; --y) {
                    int si = (y - this.minY) / 16;
                    int i = (px << 8) + ((y & 0xF) << 4) + pz;
                    BlockState st = this.cache[si].section[i];
                    if (st == null || st.isAir()) continue;
                    this.heightmap[px][pz] = y;
                    return;
                }
                this.heightmap[px][pz] = Integer.MIN_VALUE;
            }
        }

        @Nullable
        private BlockState get(BlockPos pos) {
            int sectionIdx = (pos.getY() - this.minY) / 16;
            int idx = ((pos.getX() & 0xF) << 8) + ((pos.getY() & 0xF) << 4) + (pos.getZ() & 0xF);
            return this.cache[sectionIdx].section[idx];
        }

        private void generate(BulkSectionAccess bulk) {
            for (int si = 0; si < (this.maxY - this.minY) / 16; ++si) {
                S c = this.cache[si];
                if (c.isEmpty) continue;
                int cy = si * 16 + this.minY;
                LevelChunkSection section = bulk.getSection(new BlockPos(this.cx, cy, this.cz));
                if (section == null) {
                    throw new RuntimeException("This cannot happen: " + si);
                }
                int i = 0;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            BlockState state;
                            if ((state = c.section[i++]) == null) continue;
                            section.setBlockState(x, y, z, state, false);
                        }
                    }
                }
            }
        }

        private void clear() {
            for (int si = 0; si < (this.maxY - this.minY) / 16; ++si) {
                this.cache[si] = new S();
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    this.heightmap[x][z] = Integer.MIN_VALUE;
                }
            }
        }
    }

    private static class S {
        private final BlockState[] section = new BlockState[4096];
        private boolean isEmpty = true;

        private S() {
        }
    }
}

