/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.jetbrains.annotations.Nullable;

public class DefaultDimensionInfo
implements IDimensionInfo {
    private WorldGenLevel world;
    private final LostCityProfile profile;
    private final LostCityProfile profileOutside;
    private final WorldStyle style;
    private final Random random;
    private final Registry<Biome> biomeRegistry;
    private final LostCityTerrainFeature feature;

    public DefaultDimensionInfo(WorldGenLevel world, LostCityProfile profile, LostCityProfile profileOutside) {
        this.world = world;
        this.profile = profile;
        this.profileOutside = profileOutside;
        this.style = AssetRegistries.WORLDSTYLES.get((CommonLevelAccessor)world, profile.getWorldStyle());
        this.random = new Random(world.getSeed());
        LegacyRandomSource randomSource = new LegacyRandomSource(world.getSeed());
        this.feature = new LostCityTerrainFeature(this, profile, (RandomSource)randomSource);
        this.feature.setupStates(profile);
        this.biomeRegistry = world.registryAccess().registryOrThrow(Registries.BIOME);
    }

    @Override
    public void setWorld(WorldGenLevel world) {
        this.world = world;
    }

    @Override
    public long getSeed() {
        return this.world.getSeed();
    }

    @Override
    public WorldGenLevel getWorld() {
        return this.world;
    }

    @Override
    public ResourceKey<Level> getType() {
        return this.world.getLevel().dimension();
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return this.profileOutside;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        ChunkCoord coord = new ChunkCoord(this.getType(), chunkX, chunkZ);
        return this.feature.getHeightmap(coord, this.getWorld());
    }

    @Override
    public ChunkHeightmap getHeightmap(ChunkCoord coord) {
        return this.feature.getHeightmap(coord, this.getWorld());
    }

    @Override
    public Holder<Biome> getBiome(BlockPos pos) {
        ChunkSource chunkProvider = this.getWorld().getChunkSource();
        if (chunkProvider instanceof ServerChunkCache) {
            ChunkGenerator generator = ((ServerChunkCache)chunkProvider).getGenerator();
            BiomeSource biomeProvider = generator.getBiomeSource();
            Climate.Sampler sampler = ((ServerChunkCache)chunkProvider).randomState().sampler();
            return biomeProvider.getNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2, sampler);
        }
        return this.biomeRegistry.getHolderOrThrow(Biomes.PLAINS);
    }

    @Override
    @Nullable
    public ResourceKey<Level> dimension() {
        return this.world.getLevel().dimension();
    }
}

