/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.varia.TodoQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class GlobalTodo {
    private final Map<ChunkPos, TodoQueues> todoQueues = new HashMap<ChunkPos, TodoQueues>();
    private static final Map<ResourceKey<Level>, GlobalTodo> instances = new HashMap<ResourceKey<Level>, GlobalTodo>();

    public static GlobalTodo get(Level world) {
        return instances.computeIfAbsent((ResourceKey<Level>)world.dimension(), k -> new GlobalTodo());
    }

    public void addTodo(BlockPos pos, Consumer<ServerLevel> code) {
        ChunkPos chunkPos = new ChunkPos(pos);
        TodoQueues queues = this.todoQueues.computeIfAbsent(chunkPos, k -> new TodoQueues(new TodoQueue<Consumer<ServerLevel>>()));
        queues.todo.add(pos, code);
    }

    public void executeAndClearTodo(ServerLevel level) {
        int todoSize = (Integer)Config.TODO_QUEUE_SIZE.get();
        HashSet<ChunkPos> todoToRemove = new HashSet<ChunkPos>();
        HashMap<ChunkPos, TodoQueues> copy = new HashMap<ChunkPos, TodoQueues>(this.todoQueues);
        for (Map.Entry entry : copy.entrySet()) {
            TodoQueues queues = (TodoQueues)entry.getValue();
            ChunkPos cp = (ChunkPos)entry.getKey();
            todoSize -= queues.todo.forEach(todoSize, (pos, code) -> code.accept(level));
            if (queues.isEmpty()) {
                todoToRemove.add(cp);
            }
            if (todoSize > 0) continue;
            break;
        }
        todoToRemove.forEach(this.todoQueues::remove);
    }

    record TodoQueues(TodoQueue<Consumer<ServerLevel>> todo) {
        public boolean isEmpty() {
            return this.todo.isEmpty();
        }

        public void dumpSizes() {
            System.out.println("----------------");
            System.out.println("todo = " + this.todo.getSize());
        }
    }
}

