/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Orientation;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class Doors {
    private static BlockState getDoor(Block door, boolean upper, boolean left, Direction facing) {
        return (BlockState)((BlockState)((BlockState)door.defaultBlockState().setValue((Property)DoorBlock.HALF, (Comparable)(upper ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER))).setValue((Property)DoorBlock.HINGE, (Comparable)(left ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT))).setValue((Property)DoorBlock.FACING, (Comparable)facing);
    }

    public static void generateDoors(LostCityTerrainFeature feature, BuildingInfo info, int height, int f) {
        int z;
        int x;
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockState filler = info.getCompiledPalette().get(info.getBuilding().getFillerBlock());
        ChunkDriver driver = feature.driver;
        --height;
        if (info.hasConnectionAtX(f + info.cellars)) {
            x = 0;
            if (Doors.hasConnectionWithBuilding(f, info, info.getXmin())) {
                driver.setBlockRange(x, height, 6, height + 4, filler);
                driver.setBlockRange(x, height, 9, height + 4, filler);
                driver.current(x, height, 7).add(filler).add(air).add(air).add(filler);
                driver.current(x, height, 8).add(filler).add(air).add(air).add(filler);
            } else if (Doors.hasConnectionToTopOrOutside(f, info, info.getXmin())) {
                driver.setBlockRange(x, height, 6, height + 4, filler);
                driver.setBlockRange(x, height, 9, height + 4, filler);
                driver.current(x, height, 7).add(filler).add(Doors.getDoor(info.doorBlock, false, true, Direction.EAST)).add(Doors.getDoor(info.doorBlock, true, true, Direction.EAST)).add(filler);
                driver.current(x, height, 8).add(filler).add(Doors.getDoor(info.doorBlock, false, false, Direction.EAST)).add(Doors.getDoor(info.doorBlock, true, false, Direction.EAST)).add(filler);
            }
        }
        if (Doors.hasConnectionWithBuildingMax(f, info, info.getXmax(), Orientation.X)) {
            x = 15;
            driver.setBlockRange(x, height, 6, height + 4, filler);
            driver.setBlockRange(x, height, 9, height + 4, filler);
            driver.current(x, height, 7).add(filler).add(air).add(air).add(filler);
            driver.current(x, height, 8).add(filler).add(air).add(air).add(filler);
        } else if (Doors.hasConnectionToTopOrOutside(f, info, info.getXmax()) && info.getXmax().hasConnectionAtXFromStreet(f + info.getXmax().cellars)) {
            x = 15;
            driver.setBlockRange(x, height, 6, height + 4, filler);
            driver.setBlockRange(x, height, 9, height + 4, filler);
            driver.current(x, height, 7).add(filler).add(Doors.getDoor(info.doorBlock, false, false, Direction.WEST)).add(Doors.getDoor(info.doorBlock, true, false, Direction.WEST)).add(filler);
            driver.current(x, height, 8).add(filler).add(Doors.getDoor(info.doorBlock, false, true, Direction.WEST)).add(Doors.getDoor(info.doorBlock, true, true, Direction.WEST)).add(filler);
        }
        if (info.hasConnectionAtZ(f + info.cellars)) {
            z = 0;
            if (Doors.hasConnectionWithBuilding(f, info, info.getZmin())) {
                driver.setBlockRange(6, height, z, height + 4, filler);
                driver.setBlockRange(9, height, z, height + 4, filler);
                driver.current(7, height, z).add(filler).add(air).add(air).add(filler);
                driver.current(8, height, z).add(filler).add(air).add(air).add(filler);
            } else if (Doors.hasConnectionToTopOrOutside(f, info, info.getZmin())) {
                driver.setBlockRange(6, height, z, height + 4, filler);
                driver.setBlockRange(9, height, z, height + 4, filler);
                driver.current(7, height, z).add(filler).add(Doors.getDoor(info.doorBlock, false, true, Direction.NORTH)).add(Doors.getDoor(info.doorBlock, true, true, Direction.NORTH)).add(filler);
                driver.current(8, height, z).add(filler).add(Doors.getDoor(info.doorBlock, false, false, Direction.NORTH)).add(Doors.getDoor(info.doorBlock, true, false, Direction.NORTH)).add(filler);
            }
        }
        if (Doors.hasConnectionWithBuildingMax(f, info, info.getZmax(), Orientation.Z)) {
            z = 15;
            driver.setBlockRange(6, height, z, height + 4, filler);
            driver.setBlockRange(9, height, z, height + 4, filler);
            driver.current(7, height, z).add(filler).add(air).add(air).add(filler);
            driver.current(8, height, z).add(filler).add(air).add(air).add(filler);
        } else if (Doors.hasConnectionToTopOrOutside(f, info, info.getZmax()) && info.getZmax().hasConnectionAtZFromStreet(f + info.getZmax().cellars)) {
            z = 15;
            driver.setBlockRange(6, height, z, height + 4, filler);
            driver.setBlockRange(9, height, z, height + 4, filler);
            driver.current(7, height, z).add(filler).add(Doors.getDoor(info.doorBlock, false, false, Direction.SOUTH)).add(Doors.getDoor(info.doorBlock, true, false, Direction.SOUTH)).add(filler);
            driver.current(8, height, z).add(filler).add(Doors.getDoor(info.doorBlock, false, true, Direction.SOUTH)).add(Doors.getDoor(info.doorBlock, true, true, Direction.SOUTH)).add(filler);
        }
    }

    private static boolean hasConnectionWithBuildingMax(int localLevel, BuildingInfo info, BuildingInfo info2, Orientation x) {
        if (info.isValidFloor(localLevel) && info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info2.isValidFloor(localAdjacent) && info2.getFloor(localAdjacent).getMetaBoolean("dontconnect")) {
            return false;
        }
        int level = localAdjacent + info2.cellars;
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.cellars) && info2.hasConnectionAt(level, x);
    }

    private static boolean hasConnectionToTopOrOutside(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        if (info.getFloor(localLevel).getMetaBoolean("dontconnect")) {
            return false;
        }
        return info2.isCity && !info2.hasBuilding && localLevel == 0 && localAdjacent == 0 || info2.hasBuilding && localAdjacent == info2.getNumFloors();
    }

    private static boolean hasConnectionWithBuilding(int localLevel, BuildingInfo info, BuildingInfo info2) {
        int globalLevel = info.localToGlobal(localLevel);
        int localAdjacent = info2.globalToLocal(globalLevel);
        return info2.hasBuilding && (localAdjacent >= 0 && localAdjacent < info2.getNumFloors() || localAdjacent < 0 && -localAdjacent <= info2.cellars);
    }
}

