/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Highway;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.regassets.data.HighwayParts;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class Highways {
    public static void generateHighways(LostCityTerrainFeature feature, BuildingInfo info) {
        int levelZ;
        int levelX = Highway.getXHighwayLevel(info.coord, info.provider, info.profile);
        if (levelX == (levelZ = Highway.getZHighwayLevel(info.coord, info.provider, info.profile)) && levelX >= 0) {
            Highways.generateHighwayPart(feature, info, levelX, Transform.ROTATE_NONE, info.getXmax(), info.getZmax(), true);
        } else if (levelX >= 0 && levelZ >= 0) {
            if (levelX == 0) {
                Highways.generateHighwayPart(feature, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
                Highways.generateHighwayPart(feature, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
            } else {
                Highways.generateHighwayPart(feature, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
                Highways.generateHighwayPart(feature, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
            }
        } else if (levelX >= 0) {
            Highways.generateHighwayPart(feature, info, levelX, Transform.ROTATE_NONE, info.getZmin(), info.getZmax(), false);
        } else if (levelZ >= 0) {
            Highways.generateHighwayPart(feature, info, levelZ, Transform.ROTATE_90, info.getXmax(), info.getXmax(), false);
        }
    }

    public static boolean isClearableAboveHighway(BlockState st) {
        return !st.is(BlockTags.LEAVES) && !st.is(BlockTags.LOGS);
    }

    private static void generateHighwayPart(LostCityTerrainFeature feature, BuildingInfo info, int level, Transform transform, BuildingInfo adjacent1, BuildingInfo adjacent2, boolean bidirectional) {
        BuildingPart part;
        ChunkDriver driver = feature.driver;
        int highwayGroundLevel = info.groundLevel + level * 6;
        HighwayParts highwayParts = info.provider.getWorldStyle().getPartSelector().highwayParts();
        if (info.isTunnel(level)) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)info.provider.getWorld(), feature.getRandomPart(highwayParts.tunnel(bidirectional)));
            feature.generatePart(info, part, transform, 0, highwayGroundLevel, 0, LostCityTerrainFeature.HardAirSetting.WATERLEVEL);
        } else if (info.isCity && level <= adjacent1.cityLevel && level <= adjacent2.cityLevel && adjacent1.isCity && adjacent2.isCity) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)info.provider.getWorld(), feature.getRandomPart(highwayParts.open(bidirectional)));
            height = feature.generatePart(info, part, transform, 0, highwayGroundLevel, 0, LostCityTerrainFeature.HardAirSetting.WATERLEVEL);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        feature.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, Highways::isClearableAboveHighway);
                    }
                }
            }
        } else {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)info.provider.getWorld(), feature.getRandomPart(highwayParts.bridge(bidirectional)));
            height = feature.generatePart(info, part, transform, 0, highwayGroundLevel, 0, LostCityTerrainFeature.HardAirSetting.WATERLEVEL);
            if (!info.profile.isCavern()) {
                clearheight = 15;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        feature.clearRange(info, x, z, height, height + clearheight, info.waterLevel > info.groundLevel, Highways::isClearableAboveHighway);
                    }
                }
            }
        }
        Character support = part.getMetaChar("support");
        if (info.profile.HIGHWAY_SUPPORTS && support != null) {
            BlockState sup = info.getCompiledPalette().get(support.charValue());
            if (sup == null) {
                throw new RuntimeException("Cannot find support block '" + support + "' for highway part '" + part.getName() + "'!");
            }
            int x1 = transform.rotateX(0, 15);
            int z1 = transform.rotateZ(0, 15);
            driver.current(x1, highwayGroundLevel - 1, z1);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(driver.getBlock()); ++y) {
                driver.block(sup);
                driver.decY();
            }
            int x2 = transform.rotateX(0, 0);
            int z2 = transform.rotateZ(0, 0);
            driver.current(x2, highwayGroundLevel - 1, z2);
            for (int y = 0; y < 40 && LostCityTerrainFeature.isEmpty(driver.getBlock()); ++y) {
                driver.block(sup);
                driver.decY();
            }
        }
    }
}

