/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.CitySphere;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.regassets.data.MonorailParts;
import net.minecraft.world.level.CommonLevelAccessor;

public class Monorails {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateMonorails(LostCityTerrainFeature feature, BuildingInfo info) {
        BuildingPart part;
        Transform transform;
        LostCityProfile profile = info.profile;
        IDimensionInfo provider = info.provider;
        MonorailParts monoRailParts = provider.getWorldStyle().getPartSelector().monoRailParts();
        boolean horiz = info.hasHorizontalMonorail();
        boolean vert = info.hasVerticalMonorail();
        if (horiz && vert) {
            if (CitySphere.intersectsWithCitySphere(info.coord, provider)) return;
            BuildingPart part2 = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.both());
            feature.generatePart(info, part2, Transform.ROTATE_NONE, 0, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, LostCityTerrainFeature.HardAirSetting.WATERLEVEL);
            return;
        }
        if (horiz) {
            transform = Transform.ROTATE_90;
        } else {
            if (!vert) return;
            transform = Transform.ROTATE_NONE;
        }
        if (CitySphere.fullyInsideCitySpere(info.coord, provider)) {
            if (Monorails.hasNonStationMonoRail(info.getXmin())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_90_X;
                feature.fillToGround(info, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (Monorails.hasNonStationMonoRail(info.getXmax())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_90;
                feature.fillToGround(info, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else if (Monorails.hasNonStationMonoRail(info.getZmin())) {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.ROTATE_NONE;
                feature.fillToGround(info, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            } else {
                if (!Monorails.hasNonStationMonoRail(info.getZmax())) return;
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.station());
                Character borderBlock = info.getCityStyle().getBorderBlock();
                transform = Transform.MIRROR_Z;
                feature.fillToGround(info, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, borderBlock);
            }
        } else {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), monoRailParts.vertical());
        }
        feature.generatePart(info, part, transform, 0, profile.GROUNDLEVEL + profile.CITYSPHERE_MONORAIL_HEIGHT_OFFSET, 0, LostCityTerrainFeature.HardAirSetting.WATERLEVEL);
    }

    private static boolean hasNonStationMonoRail(BuildingInfo info) {
        return info.hasMonorail() && !CitySphere.fullyInsideCitySpere(info.coord, info.provider);
    }
}

