/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiTools {
    public static int getRelativeX(Screen gui) {
        Minecraft mc = Minecraft.getInstance();
        int mainWidth = mc.getWindow().getScreenWidth();
        if (mainWidth <= 0) {
            return 0;
        }
        MouseHandler mouse = mc.mouseHandler;
        int mouseX = (int)mouse.xpos();
        return mouseX * gui.width / mainWidth;
    }

    public static int getRelativeY(Screen gui) {
        Minecraft mc = Minecraft.getInstance();
        int mainHeight = mc.getWindow().getScreenHeight();
        if (mainHeight <= 0) {
            return 0;
        }
        MouseHandler mouse = mc.mouseHandler;
        int mouseY = (int)mouse.ypos();
        return mouseY * gui.height / mainHeight;
    }

    public static boolean openRemoteGui(@Nonnull Player player, @Nullable ResourceKey<Level> dimensionType, @Nonnull BlockPos pos) {
        return GuiTools.openRemoteGui(player, dimensionType, pos, te -> new MenuProvider((BlockEntity)te){
            final /* synthetic */ BlockEntity val$te;
            {
                this.val$te = blockEntity;
            }

            @Nonnull
            public Component getDisplayName() {
                return ComponentFactory.literal("Remote Gui");
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
                MenuProvider h = (MenuProvider)this.val$te.getLevel().getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY, this.val$te.getBlockPos(), null);
                if (h != null) {
                    return h.createMenu(id, inventory, player);
                }
                return null;
            }
        });
    }

    public static boolean openRemoteGui(@Nonnull Player player, @Nullable ResourceKey<Level> dimensionType, @Nonnull BlockPos pos, Function<BlockEntity, MenuProvider> provider) {
        ServerLevel world;
        if (dimensionType == null) {
            dimensionType = player.getCommandSenderWorld().dimension();
        }
        if (!LevelTools.isLoaded((Level)(world = LevelTools.getLevel(player.getCommandSenderWorld(), (ResourceKey<Level>)dimensionType)), pos)) {
            player.displayClientMessage((Component)ComponentFactory.literal(String.valueOf(ChatFormatting.RED) + "Position is not loaded!"), false);
            return false;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            player.displayClientMessage((Component)ComponentFactory.literal(String.valueOf(ChatFormatting.RED) + "Tile entity is missing!"), false);
            return false;
        }
        CompoundTag written = te.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
        player.openMenu(provider.apply(te), arg_0 -> GuiTools.lambda$openRemoteGui$1(pos, (Level)world, written, arg_0));
        return true;
    }

    private static /* synthetic */ void lambda$openRemoteGui$1(BlockPos pos, Level world, CompoundTag written, RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(pos);
        buf.writeResourceLocation(world.dimension().location());
        buf.writeNbt((Tag)written);
    }
}

