/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.joml.Matrix4f;

public class QuadTransformer {
    private static void processVertices(Matrix4f transform, VertexFormat fmt, int positionIndex, int[] inData, int[] outData) {
        int positionOffset = 0;
        int stride = fmt.getVertexSize() / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = positionOffset + i * stride;
            float x = Float.intBitsToFloat(inData[offset]);
            float y = Float.intBitsToFloat(inData[offset + 1]);
            float f = Float.intBitsToFloat(inData[offset + 2]);
        }
    }

    private static int findPositionIndex(VertexFormat fmt) {
        int positionIndex;
        VertexFormatElement positionElement = null;
        List list = fmt.getElements();
        for (positionIndex = 0; positionIndex < list.size(); ++positionIndex) {
            VertexFormatElement el = (VertexFormatElement)list.get(positionIndex);
            if (el.usage() != VertexFormatElement.Usage.POSITION) continue;
            positionElement = el;
            break;
        }
        if (positionIndex == list.size() || positionElement == null) {
            throw new RuntimeException("WAT? Position not found");
        }
        if (positionElement.type() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("WAT? Position not FLOAT");
        }
        if (positionElement.byteSize() < 3) {
            throw new RuntimeException("WAT? Position not 3D");
        }
        return positionIndex;
    }

    public static BakedQuad processOne(BakedQuad input, Matrix4f transform) {
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        int[] data = input.getVertices();
        QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        return new BakedQuad(data, input.getTintIndex(), input.getDirection(), input.getSprite(), input.isShade());
    }

    public static List<BakedQuad> processMany(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.getVertices();
            int[] outData = Arrays.copyOf(inData, inData.length);
            QuadTransformer.processVertices(transform, fmt, positionIndex, inData, outData);
            outputs.add(new BakedQuad(outData, input.getTintIndex(), input.getDirection(), input.getSprite(), input.isShade()));
        }
        return outputs;
    }

    public static void processManyInPlace(List<BakedQuad> inputs, Matrix4f transform) {
        if (inputs.isEmpty()) {
            return;
        }
        VertexFormat fmt = null;
        int positionIndex = QuadTransformer.findPositionIndex(fmt);
        for (BakedQuad input : inputs) {
            int[] data = input.getVertices();
            QuadTransformer.processVertices(transform, fmt, positionIndex, data, data);
        }
    }
}

