/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class GenericItemHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    private final GenericTileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private final ItemStackHandler stacks;

    public static BiPredicate<Integer, ItemStack> slot(int s) {
        return (slot, stack) -> slot == s;
    }

    public static BiPredicate<Integer, ItemStack> notslot(int s) {
        return (slot, stack) -> slot != s;
    }

    public static BiPredicate<Integer, ItemStack> match(Supplier<? extends Item> itemSupplier) {
        Item item = itemSupplier.get();
        return (slot, stack) -> stack.getItem() == item;
    }

    public static BiPredicate<Integer, ItemStack> match(Item item) {
        return (slot, stack) -> stack.getItem() == item;
    }

    public static BiPredicate<Integer, ItemStack> no() {
        return (slot, stack) -> false;
    }

    public static BiPredicate<Integer, ItemStack> yes() {
        return (slot, stack) -> true;
    }

    public static Builder create(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
        return new Builder(te, factorySupplier);
    }

    public static GenericItemHandler basic(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
        return new GenericItemHandler(te, factorySupplier.get());
    }

    protected void onUpdate(int index, ItemStack stack) {
        this.tileEntity.markDirtyQuick();
    }

    public GenericItemHandler(GenericTileEntity te, ContainerFactory factory) {
        this.tileEntity = te;
        this.containerFactory = factory;
        this.stacks = new ItemStackHandler(this.containerFactory.getContainerSlots());
    }

    public void applyImplicitComponents(ItemInventory inventory) {
        if (inventory != null) {
            this.setStacks(inventory.items());
        }
    }

    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots(); ++i) {
            stacks.add(this.getStackInSlot(i));
        }
        builder.set(Registration.ITEM_INVENTORY, (Object)new ItemInventory(stacks));
    }

    public ItemStackHandler getStacks() {
        return this.stacks;
    }

    public void setStacks(List<ItemStack> items) {
        for (int i = 0; i < this.stacks.getSlots(); ++i) {
            if (i < items.size()) {
                this.stacks.setStackInSlot(i, items.get(i));
                continue;
            }
            this.stacks.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getSlots() {
        return this.stacks.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.stacks.getSlots()) {
            return ItemStack.EMPTY;
        }
        return this.stacks.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemInsertable(slot, stack)) {
            return stack;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.setInventorySlotContents(copy.getMaxStackSize(), slot, copy);
                    this.onUpdate(slot, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.setInventorySlotContents(copy.getMaxStackSize(), slot, copy);
                this.onUpdate(slot, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                ItemStack split = stack.split(m);
                this.setInventorySlotContents(stack.getMaxStackSize(), slot, split);
                this.onUpdate(slot, split);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(stack.getMaxStackSize(), slot, stack);
            this.onUpdate(slot, stack);
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.getSlots()) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (!stack.isEmpty()) {
                ItemStack stack1 = stack.copy();
                if (index < 9) {
                    stack1.setCount(1);
                }
                this.stacks.setStackInSlot(index, stack1);
            } else {
                this.stacks.setStackInSlot(index, ItemStack.EMPTY);
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            if (!stack.isEmpty()) {
                this.stacks.setStackInSlot(index, stack.copy());
            } else {
                this.stacks.setStackInSlot(index, ItemStack.EMPTY);
            }
        } else {
            this.stacks.setStackInSlot(index, stack);
            if (!stack.isEmpty() && stack.getCount() > stackLimit) {
                stack.setCount(Math.max(stackLimit, 0));
            }
            this.tileEntity.setChanged();
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemExtractable(slot, stackInSlot)) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        this.onUpdate(slot, decrStackSize);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.getSlots()) {
            return ItemStack.EMPTY;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = this.stacks.getStackInSlot(index);
            this.stacks.setStackInSlot(index, ItemStack.EMPTY);
            if (old.isEmpty()) {
                return ItemStack.EMPTY;
            }
            old.setCount(0);
            return old;
        }
        if (!this.stacks.getStackInSlot(index).isEmpty()) {
            if (this.stacks.getStackInSlot(index).getCount() <= amount) {
                ItemStack old = this.stacks.getStackInSlot(index);
                this.stacks.setStackInSlot(index, ItemStack.EMPTY);
                this.tileEntity.setChanged();
                return old;
            }
            ItemStack its = this.stacks.getStackInSlot(index).split(amount);
            if (this.stacks.getStackInSlot(index).isEmpty()) {
                this.stacks.setStackInSlot(index, ItemStack.EMPTY);
            }
            this.tileEntity.setChanged();
            return its;
        }
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.setStackInSlot(slot, stack);
        this.onUpdate(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.stacks.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stacks.deserializeNBT(provider, nbt);
    }

    public void save(CompoundTag tag, String tagName, HolderLookup.Provider provider) {
        tag.put(tagName, (Tag)this.serializeNBT(provider));
    }

    public void load(CompoundTag tag, String tagName, HolderLookup.Provider provider) {
        if (tag.contains(tagName)) {
            this.deserializeNBT(provider, tag.getCompound(tagName));
        }
    }

    public static class Builder {
        private final GenericTileEntity te;
        private final Supplier<ContainerFactory> factorySupplier;
        private BiPredicate<Integer, ItemStack> itemValid = (slot, stack) -> true;
        private BiPredicate<Integer, ItemStack> insertable = null;
        private BiPredicate<Integer, ItemStack> extractable = (slot, stack) -> true;
        private BiConsumer<Integer, ItemStack> onUpdate = (slot, stack) -> {};
        private Function<Integer, Integer> slotLimit = s -> 64;

        public Builder(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
            this.te = te;
            this.factorySupplier = factorySupplier;
        }

        public Builder slotLimit(int slotLimit) {
            this.slotLimit = s -> slotLimit;
            return this;
        }

        public Builder slotLimit(Function<Integer, Integer> slotLimit) {
            this.slotLimit = slotLimit;
            return this;
        }

        public Builder itemValid(BiPredicate<Integer, ItemStack> itemValid) {
            this.itemValid = itemValid;
            return this;
        }

        public Builder insertable(BiPredicate<Integer, ItemStack> insertable) {
            this.insertable = insertable;
            return this;
        }

        public Builder extractable(BiPredicate<Integer, ItemStack> extractable) {
            this.extractable = extractable;
            return this;
        }

        public Builder onUpdate(BiConsumer<Integer, ItemStack> onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public GenericItemHandler build() {
            return new GenericItemHandler(this.te, this.factorySupplier.get()){

                @Override
                public int getSlotLimit(int slot) {
                    return slotLimit.apply(slot);
                }

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    return itemValid.test(slot, stack);
                }

                @Override
                public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                    if (insertable == null) {
                        return this.isItemValid(slot, stack);
                    }
                    return insertable.test(slot, stack);
                }

                @Override
                public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
                    return extractable.test(slot, stack);
                }

                @Override
                protected void onUpdate(int index, ItemStack stack) {
                    super.onUpdate(index, stack);
                    onUpdate.accept(index, stack);
                }
            };
        }
    }
}

