/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.items;

import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GenericArmorItem
extends ArmorItem {
    public GenericArmorItem(Holder<ArmorMaterial> material, EquipmentSlot slot, Item.Properties properties) {
        super(material, GenericArmorItem.convert(slot), properties);
    }

    private static ArmorItem.Type convert(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> ArmorItem.Type.HELMET;
            case EquipmentSlot.CHEST -> ArmorItem.Type.CHESTPLATE;
            case EquipmentSlot.LEGS -> ArmorItem.Type.LEGGINGS;
            case EquipmentSlot.FEET -> ArmorItem.Type.BOOTS;
            default -> throw new IllegalArgumentException("Unknown slot: " + String.valueOf(slot));
        };
    }

    public static EquipmentSlot getSlotForItem(ItemStack stack) {
        return ((ArmorItem)stack.getItem()).getEquipmentSlot();
    }
}

