/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.worlddata;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public abstract class AbstractLocalWorldData<T extends AbstractLocalWorldData<T>>
extends SavedData {
    protected AbstractLocalWorldData() {
    }

    public void save() {
        this.setDirty();
    }

    @Nonnull
    public static <T extends AbstractLocalWorldData<T>> T getData(Level world, Function<CompoundTag, T> loader, Supplier<T> supplier, String name) {
        if (world.isClientSide) {
            throw new RuntimeException("Don't access this client-side!");
        }
        DimensionDataStorage storage = ((ServerLevel)world).getDataStorage();
        return (T)((Object)((AbstractLocalWorldData)storage.computeIfAbsent(new SavedData.Factory(supplier, (tag, provider) -> (AbstractLocalWorldData)((Object)((Object)loader.apply((CompoundTag)tag)))), name)));
    }
}

