/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ParameterSerializerHelpers {
    private static final EnumMap<ParameterType, ConstantSerializer> CONSTANT_SERIALIZERS = new EnumMap(ParameterType.class);
    private static final String NUMBER_KIND_KEY = "kind";
    private static final String NUMBER_VALUE_KEY = "value";
    private static FunctionResolver functionResolver = id -> null;

    public static void setFunctionResolver(FunctionResolver resolver) {
        functionResolver = Objects.requireNonNull(resolver);
    }

    public static void registerSerializer(ParameterType type, ConstantSerializer serializer) {
        CONSTANT_SERIALIZERS.put(Objects.requireNonNull(type), Objects.requireNonNull(serializer));
    }

    public static Function resolveFunction(String id) {
        return functionResolver == null ? null : functionResolver.resolve(id);
    }

    public static ConstantSerializer requireSerializer(ParameterType type) {
        ConstantSerializer serializer = CONSTANT_SERIALIZERS.get((Object)type);
        if (serializer == null) {
            throw new IllegalStateException("No serializer registered for parameter type " + String.valueOf((Object)type));
        }
        return serializer;
    }

    public static <T> DataResult<T> encodeConstant(DynamicOps<T> ops, ParameterType type, Object value) {
        ConstantSerializer serializer = CONSTANT_SERIALIZERS.get((Object)type);
        if (serializer == null) {
            return DataResult.error(() -> "No serializer registered for parameter type " + String.valueOf((Object)type));
        }
        return serializer.encode(ops, value);
    }

    public static <T> DataResult<Object> decodeConstant(DynamicOps<T> ops, ParameterType type, T value) {
        ConstantSerializer serializer = CONSTANT_SERIALIZERS.get((Object)type);
        if (serializer == null) {
            return DataResult.error(() -> "No serializer registered for parameter type " + String.valueOf((Object)type));
        }
        return serializer.decode(ops, value);
    }

    private static ConstantSerializer numberSerializer() {
        return new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                if (!(value instanceof Number)) {
                    return DataResult.error(() -> "Expected Number, got " + String.valueOf(value));
                }
                Number number = (Number)value;
                String kind = ParameterSerializerHelpers.numberKind(number);
                Object kindElement = ops.createString(kind);
                Object numberElement = switch (kind) {
                    case "int" -> ops.createInt(number.intValue());
                    case "long" -> ops.createLong(number.longValue());
                    case "float" -> ops.createFloat(number.floatValue());
                    case "double" -> ops.createDouble(number.doubleValue());
                    default -> throw new IllegalStateException("Unknown number kind: " + kind);
                };
                RecordBuilder builder = ops.mapBuilder();
                builder.add(ParameterSerializerHelpers.NUMBER_KIND_KEY, kindElement);
                builder.add(ParameterSerializerHelpers.NUMBER_VALUE_KEY, numberElement);
                return builder.build(ops.empty());
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> {
                    Object kindElement = map.get(ParameterSerializerHelpers.NUMBER_KIND_KEY);
                    if (kindElement == null) {
                        return DataResult.error(() -> "Missing number kind");
                    }
                    Object valueElement = map.get(ParameterSerializerHelpers.NUMBER_VALUE_KEY);
                    if (valueElement == null) {
                        return DataResult.error(() -> "Missing number value");
                    }
                    return ops.getStringValue(kindElement).flatMap(kind -> ops.getNumberValue(valueElement).map(number -> switch (kind) {
                        case "int" -> number.intValue();
                        case "long" -> number.longValue();
                        case "float" -> Float.valueOf(number.floatValue());
                        case "double" -> number.doubleValue();
                        default -> throw new IllegalStateException("Unknown number kind: " + kind);
                    }));
                });
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                Number number = (Number)value;
                switch (ParameterSerializerHelpers.numberKind(number)) {
                    case "int": {
                        buf.writeByte(0);
                        buf.writeInt(number.intValue());
                        break;
                    }
                    case "long": {
                        buf.writeByte(1);
                        buf.writeLong(number.longValue());
                        break;
                    }
                    case "float": {
                        buf.writeByte(2);
                        buf.writeFloat(number.floatValue());
                        break;
                    }
                    case "double": {
                        buf.writeByte(3);
                        buf.writeDouble(number.doubleValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown number kind");
                    }
                }
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return switch (buf.readByte()) {
                    case 0 -> buf.readInt();
                    case 1 -> buf.readLong();
                    case 2 -> Float.valueOf(buf.readFloat());
                    case 3 -> buf.readDouble();
                    default -> throw new IllegalStateException("Unknown number kind");
                };
            }
        };
    }

    private static String numberKind(Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return "int";
        }
        if (number instanceof Long) {
            return "long";
        }
        if (number instanceof Float) {
            return "float";
        }
        if (number instanceof Double) {
            return "double";
        }
        return "double";
    }

    static {
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_STRING, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return DataResult.success((Object)ops.createString((String)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getStringValue(input).map(s -> s);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                buf.writeUtf((String)value);
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return buf.readUtf();
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_INTEGER, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return DataResult.success((Object)ops.createInt(((Integer)value).intValue()));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getNumberValue(input).map(number -> number.intValue());
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                buf.writeInt(((Integer)value).intValue());
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return buf.readInt();
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_LONG, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return DataResult.success((Object)ops.createLong(((Long)value).longValue()));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getNumberValue(input).map(number -> number.longValue());
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                buf.writeLong(((Long)value).longValue());
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return buf.readLong();
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_FLOAT, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return DataResult.success((Object)ops.createFloat(((Float)value).floatValue()));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getNumberValue(input).map(number -> Float.valueOf(number.floatValue()));
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                buf.writeFloat(((Float)value).floatValue());
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return Float.valueOf(buf.readFloat());
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_BOOLEAN, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return DataResult.success((Object)ops.createBoolean(((Boolean)value).booleanValue()));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ops.getBooleanValue(input).map(bool -> bool);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                buf.writeBoolean(((Boolean)value).booleanValue());
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return buf.readBoolean();
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_SIDE, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return BlockSide.CODEC.encodeStart(ops, (Object)((BlockSide)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return BlockSide.CODEC.parse(ops, input).map(side -> side);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                BlockSide.STREAM_CODEC.encode((Object)buf, (Object)((BlockSide)value));
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return BlockSide.STREAM_CODEC.decode((Object)buf);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_INVENTORY, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return Inventory.CODEC.encodeStart(ops, (Object)((Inventory)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return Inventory.CODEC.parse(ops, input).map(inv -> inv);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                Inventory.STREAM_CODEC.encode((Object)buf, (Object)((Inventory)value));
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return Inventory.STREAM_CODEC.decode((Object)buf);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_ITEM, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return ItemStack.CODEC.encodeStart(ops, (Object)((ItemStack)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return ItemStack.CODEC.parse(ops, input).map(stack -> stack);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                ItemStack.STREAM_CODEC.encode((Object)buf, (Object)((ItemStack)value));
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return ItemStack.STREAM_CODEC.decode((Object)buf);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_FLUID, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return FluidStack.CODEC.encodeStart(ops, (Object)((FluidStack)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return FluidStack.CODEC.parse(ops, input).map(stack -> stack);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                FluidStack.STREAM_CODEC.encode((Object)buf, (Object)((FluidStack)value));
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return FluidStack.STREAM_CODEC.decode((Object)buf);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_TUPLE, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                return Tuple.CODEC.encodeStart(ops, (Object)((Tuple)value));
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return Tuple.CODEC.parse(ops, input).map(tuple -> tuple);
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                Tuple.STREAM_CODEC.encode((Object)buf, (Object)((Tuple)value));
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                return Tuple.STREAM_CODEC.decode((Object)buf);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_VECTOR, new ConstantSerializer(){

            @Override
            public <T> DataResult<T> encode(DynamicOps<T> ops, Object value) {
                List list = (List)value;
                return Parameter.CODEC.listOf().encodeStart(ops, (Object)list);
            }

            @Override
            public <T> DataResult<Object> decode(DynamicOps<T> ops, T input) {
                return Parameter.CODEC.listOf().parse(ops, input).map(list -> List.copyOf(list));
            }

            @Override
            public void encodeToNetwork(RegistryFriendlyByteBuf buf, Object value) {
                List list = (List)value;
                buf.writeInt(list.size());
                for (Parameter parameter : list) {
                    Parameter.STREAM_CODEC.encode((Object)buf, (Object)parameter);
                }
            }

            @Override
            public Object decodeFromNetwork(RegistryFriendlyByteBuf buf) {
                int size = buf.readInt();
                ArrayList<Parameter> list = new ArrayList<Parameter>(size);
                for (int i = 0; i < size; ++i) {
                    list.add((Parameter)Parameter.STREAM_CODEC.decode((Object)buf));
                }
                return List.copyOf(list);
            }
        });
        ParameterSerializerHelpers.registerSerializer(ParameterType.PAR_NUMBER, ParameterSerializerHelpers.numberSerializer());
    }

    @FunctionalInterface
    public static interface FunctionResolver {
        @Nullable
        public Function resolve(String var1);
    }

    public static interface ConstantSerializer {
        public <T> DataResult<T> encode(DynamicOps<T> var1, Object var2);

        public <T> DataResult<Object> decode(DynamicOps<T> var1, T var2);

        public void encodeToNetwork(RegistryFriendlyByteBuf var1, Object var2);

        public Object decodeFromNetwork(RegistryFriendlyByteBuf var1);
    }
}

